/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.animation;

import icyllis.modernui.animation.Interpolator;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.util.math.MathHelper;

public class Applier {
    private final float startValue;
    private final float endValue;
    private float logicStart;
    private float logicEnd;
    private final Supplier<Float> getter;
    private final Consumer<Float> setter;
    @Nonnull
    private Interpolator interpolator = Interpolator.LINEAR;

    public Applier(float startValue, float endValue, Supplier<Float> getter, Consumer<Float> setter) {
        this.startValue = startValue;
        this.endValue = endValue;
        this.getter = getter;
        this.setter = setter;
    }

    public Applier setInterpolator(@Nonnull Interpolator interpolator) {
        this.interpolator = interpolator;
        return this;
    }

    void record(boolean inverted, boolean isFull) {
        this.logicStart = isFull ? (inverted ? this.endValue : this.startValue) : this.getter.get().floatValue();
        this.logicEnd = inverted ? this.startValue : this.endValue;
    }

    void update(float progress) {
        progress = this.interpolator.getInterpolation(progress);
        float value = MathHelper.func_219799_g((float)progress, (float)this.logicStart, (float)this.logicEnd);
        this.setter.accept(Float.valueOf(value));
    }
}

